﻿using System;
using System.IO;
using System.Linq;
using DicomObjects;
using DicomObjects.Enums;
using System.Text.RegularExpressions;

namespace SCP
{
    internal static class Utils_LINQ
    {
        internal static IQueryable<ExamsScheduled> AddDateCondition(IQueryable<ExamsScheduled> exams, DicomAttribute DateCondition)
        {
            if (DateCondition.ExistsWithValue && !string.IsNullOrEmpty(DateCondition.Value.ToString()) && DateCondition.Value.ToString() != "*")
            {
                if (DateCondition.Value.ToString().IndexOf("-", StringComparison.Ordinal) == -1) // if Single Date
                {
                    DateTime t = DateCondition.DateTimeTo;
                    t = t.Add(new TimeSpan(23, 59, 59));
                    exams = exams.Where(x => x.ExamDateAndTime.Value.Date.Equals(t));
                }
                else
                    exams = exams.Where(x => x.ExamDateAndTime <= DateCondition.DateTimeTo);

                exams = exams.Where(x => x.ExamDateAndTime >= DateCondition.DateTimeFrom);
            }

            return exams;
        }

        internal static IQueryable<ExamsScheduled> AddDateTimeCondition(IQueryable<ExamsScheduled> exams, DicomAttribute DateCondition, DicomAttribute TimeCondition)
        {
            if (!string.IsNullOrEmpty(DateCondition.Value.ToString()) && DateCondition.Value.ToString() != "*" && !string.IsNullOrEmpty(TimeCondition.Value.ToString()) && TimeCondition.Value.ToString() != "*")
            {
                if (DateCondition.Value.ToString().IndexOf("-", StringComparison.Ordinal) == -1) // if Single Date
                {
                    DateTime t = DateCondition.DateTimeTo;
                    DateTime startTime = TimeCondition.DateTimeFrom;
                    DateTime endTime = TimeCondition.DateTimeTo;
                    DateTime startDateTime = t.Add(new TimeSpan(startTime.Hour, startTime.Minute, startTime.Second));
                    DateTime endDateTime = t.Add(new TimeSpan(endTime.Hour, endTime.Minute, endTime.Second));
                    exams = exams.Where(x => x.ExamDateAndTime >= startDateTime && x.ExamDateAndTime <= endDateTime);
                }
                else if (DateCondition.Value.ToString().IndexOf("-", StringComparison.Ordinal) == 0) // -YYYYMMDD format
                {
                    DateTime t = DateCondition.DateTimeTo;
                    DateTime endTime = TimeCondition.DateTimeTo;
                    DateTime endDateTime = t.Add(new TimeSpan(endTime.Hour, endTime.Minute, endTime.Second));
                    exams = exams.Where(x => x.ExamDateAndTime <= endDateTime);
                }
                else if (DateCondition.Value.ToString().IndexOf("-", StringComparison.Ordinal) == DateCondition.Value.ToString().Length - 1) // YYYYMMDD- format
                {
                    DateTime t = DateCondition.DateTimeFrom;
                    DateTime startTime = TimeCondition.DateTimeFrom;
                    DateTime startDateTime = t.Add(new TimeSpan(startTime.Hour, startTime.Minute, startTime.Second));
                    exams = exams.Where(x => x.ExamDateAndTime >= startDateTime);
                }
                else // YYYYMMDD-YYYYMMDD format
                {
                    DateTime startDate = DateCondition.DateTimeFrom;
                    DateTime endDate = DateCondition.DateTimeTo;
                    DateTime startTime = TimeCondition.DateTimeFrom;
                    DateTime endTime = TimeCondition.DateTimeTo;
                    DateTime startDateTime = startDate.Add(new TimeSpan(startTime.Hour, startTime.Minute, startTime.Second));
                    DateTime endDateTime = endDate.Add(new TimeSpan(endTime.Hour, endTime.Minute, endTime.Second));
                    exams = exams.Where(x => x.ExamDateAndTime >= startDateTime && x.ExamDateAndTime <= endDateTime);
                }
            }
            return exams;
        }

        //Splits patient name into 2 separte strings surname and forename and send then to the addstringcondition subroutine.
        internal static IQueryable<ExamsScheduled> AddNameCondition(IQueryable<ExamsScheduled> exams, DicomAttribute condition)
        {
            string ptname;
            string surname;
            string forename;
            string[] nameelements;
            string delstr = "^";

            char[] del = delstr.ToCharArray();
            if (condition.Exists)
            {
                ptname = condition.Value + "^^^^";

                if (!string.IsNullOrEmpty(ptname) && ptname != "*")
                {
                    nameelements = ptname.Split(del);
                    surname = (string)nameelements.GetValue(0);
                    forename = (string)nameelements.GetValue(1);

                    if (!string.IsNullOrEmpty(surname) && surname != "*")
                    {
                        if (surname.Contains("*"))
                        {
                            Regex r = new Regex(DicomToRegex(surname));
                            exams = exams.Where(x => r.IsMatch(x.Surname));
                        }
                        else
                        {
                            exams = exams.Where(x => x.Surname == surname);
                        }
                    }


                }
            }
            return exams;
        }

        internal static string CleanString(string s)
        {
            return s.Replace("'", "''");
        }

        internal static string DicomToRegex(string dicom)
        {
            return CleanString($"^{dicom.Replace("*", ".*?")}$");
        }
    }
}

